local pn = ...
assert(pn, "DifficultySelect: need a player, dingus");
local flip = (pn == PLAYER_2);

return Def.ActorFrame{
	InitCommand=function(self)
		self:y(SCREEN_BOTTOM-150);
		if flip then
			self:x(SCREEN_WIDTH*.75+100)
			self:rotationy(180);
		else
			self:x(SCREEN_WIDTH/4-100)
		end;
	end;

	LoadActor("Disk00")..{
		Name="BigDisk";
		InitCommand=cmd(zoom,7;diffusealpha,0);
		UnselectedCommand=cmd(decelerate,.3;zoom,7;diffusealpha,0);
		SelectedCommand=cmd(decelerate,.3;zoom,2;diffusealpha,1;);
		FinishedCommand=cmd(decelerate,.5;zoom,0;xy,185,-SCREEN_HEIGHT*.67;sleep,0;xy,0,0);
		DifficultyChangedMessageCommand=function(self,params)
			if params.Player ~= PlayerNumber:Reverse()[pn] then return end;
			if self:GetRotationZ() >= 360 or self:GetRotationZ() <= -360 then
				self:rotationz(0);
			end;
			self:linear(.2):addrotationz(60*params.Direction);
		end;
	};
	
	LoadActor("Disk01")..{
		Name="SmallDisk";
		InitCommand=cmd(zoom,0;spin;effectmagnitude,0,0,50);
		UnselectedCommand=cmd(decelerate,.3;zoom,0);
		SelectedCommand=cmd(decelerate,.3;zoom,2);
		FinishedCommand=cmd(decelerate,.5;zoom,0;xy,185,-SCREEN_HEIGHT*.67;sleep,0;xy,0,0);
	};
	
	Def.ActorFrame{
		Name="Difflabel";
		InitCommand=cmd(diffusealpha,0;xy,-250,-75;);
		SelectedCommand=cmd(decelerate,.3;x,-200;diffusealpha,1);
		UnselectedCommand=cmd(decelerate,.3;x,-250;diffusealpha,0;);
		FinishedCommand=cmd(playcommand,"Unselected");
		--Top
		LoadActor("Difflabel")..{
			InitCommand=cmd(zoom,.75;horizalign,left;diffuse,color(".5,.5,.5,1");xy,-150,-125);
			DifficultyChangedMessageCommand=function(self,params)
				if params.Player ~= PlayerNumber:Reverse()[pn] then return end;
				self:xy(-150,-125):diffuse(color(".5,.5,.5,1"));
				if params.Direction == -1 then
					self:linear(.15):xy(-500,0);
				else
					self:linear(.15):xy(0,0):diffuse(color("White"));
				end;
			end;
		};
		--Mid
		LoadActor("Difflabel")..{
			InitCommand=cmd(zoom,.75;horizalign,left;);
			DifficultyChangedMessageCommand=function(self,params)
				if params.Player ~= PlayerNumber:Reverse()[pn] then return end;
				self:xy(0,0):diffuse(Color("White"));
				if params.Direction == -1 then
					self:linear(.15):xy(-150,-125):diffuse(color(".5,.5,.5,1"));
				else
					self:linear(.15):xy(-150,200):diffuse(color(".5,.5,.5,1"));
				end;
			end;
		};
		--Bottom
		LoadActor("Difflabel")..{
			InitCommand=cmd(zoom,.75;horizalign,left;diffuse,color(".5,.5,.5,1");xy,-150,200;);
			DifficultyChangedMessageCommand=function(self,params)
				if params.Player ~= PlayerNumber:Reverse()[pn] then return end;
				self:xy(-150,200):diffuse(color(".5,.5,.5,1"));
				if params.Direction == -1 then
					self:linear(.15):xy(0,0):diffuse(color("1,1,1,1"));
				else
					self:linear(.15):xy(-500,0)
				end;
			end;
		};
		
		--Hidden, when scrolling up will come from bottom, when scrolling down will come from left.
		LoadActor("Difflabel")..{
			InitCommand=cmd(zoom,.75;horizalign,left;diffuse,color(".5,.5,.5,1");xy,-500,0);
			DifficultyChangedMessageCommand=function(self,params)
				if params.Player ~= PlayerNumber:Reverse()[pn] then return end;
				self:xy(-500,0):diffuse(color(".5,.5,.5,1"));
				if params.Direction == -1 then
					self:linear(.15):xy(-150,200)
				else
					self:linear(.15):xy(-150,-125)
				end;
			end;
		};
		
		LoadActor("styletext 1x5")..{
			--Name="text";
			InitCommand=cmd(animate,false;xy,10,3;zoom,1.5;horizalign,left);
			OnCommand=function(self)
				self:setstate(MBSTATE:GetDifficulty(pn));
				if flip then
					self:rotationy(-180):horizalign(right);
				end;
			end;
			DifficultyChangedMessageCommand=function(self,params)
				if params.Player ~= PlayerNumber:Reverse()[pn] then return end;
				self:stoptweening():diffusealpha(0):sleep(.15):setstate(MBSTATE:GetDifficulty(pn)):diffusealpha(1);
			end;
		};
		
		LoadActor(THEME:GetPathG("","DifficultyIcons 6x1"))..{
			Name="Moon";
			InitCommand=cmd(animate,false;x,320);
			OnCommand=cmd(setstate,MBSTATE:GetDifficulty(pn););
			DifficultyChangedMessageCommand=function(self,params)
				if params.Player ~= PlayerNumber:Reverse()[pn] then return end;
				self:stoptweening():diffusealpha(0):sleep(.15):setstate(MBSTATE:GetDifficulty(pn)):diffusealpha(1);
			end;
		};
	};
	
	Def.ActorFrame{
		Name="Diffinfo";
		InitCommand=cmd(x,-300;diffusealpha,0);
		SelectedCommand=cmd(decelerate,.3;x,-200;diffusealpha,1);
		UnselectedCommand=cmd(decelerate,.3;x,-300;diffusealpha,0;);
		FinishedCommand=cmd(playcommand,"Unselected");
		LoadActor("Diffinfo")..{
			InitCommand=cmd(horizalign,left);
		};
		
		LoadFont("_noto sans 20px")..{
			--Text="Balanced style with simplified control. Has automatic release, reverse beat, and auto spark.";
			InitCommand=cmd(horizalign,left;x,30;wrapwidthpixels,300);
			OnCommand=function(self)
				self:settext(THEME:GetString("ScreenSelectCharacter",ToEnumShortString(Difficulty[MBSTATE:GetDifficulty(pn)+1])));
				if flip then
					self:rotationy(-180):horizalign(right);
				end;
			end;
			DifficultyChangedMessageCommand=function(self, params)
				if params.Player ~= PlayerNumber:Reverse()[pn] then return end;
				self:stoptweening():diffusealpha(0):linear(.3):diffusealpha(1);
				self:settext(THEME:GetString("ScreenSelectCharacter",ToEnumShortString(Difficulty[MBSTATE:GetDifficulty(pn)+1])))
			end;
		};
	};
	
};